/*****************************************************************************
 *   eeprom.h:  I2C functionality header file for NXP LPC29xx Family 
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
#ifndef __EEPROM_H 
#define __EEPROM_H

#define EEPROM_INTERRUPT_ENABLED	1

#define EEPROM_PAGE_INDEX			0		// Page number of the page to read and write from
#define EEPROM_PAGE_SIZE			64	
#define EEPROM_PAGE_NUM				256

#define EEPROM_SAVED 				2		// EEPROM status saved				

/* define the number of sys-clocks needed for the different phases */
/* @100MHz 1 clock = 10ns */
#define EE_PHASE1 5            // spec 35ns
#define EE_PHASE2 7            // spec 55ns
#define EE_PHASE3 3            // spec 15ns

#define EORW      (0x01<<26)	/* End of Read / Write operation */
#define EOBS      (0x01<<27)	/* End of BIST operation */
#define EOP1      (0x01<<28)	/* End of Program operation on EEPROM device 1 */

#define READ8     0
#define READ16    1
#define READ32    2
#define WRITE8    3
#define WRITE16   4
#define WRITE32   5 
#define PROGRAM   6
#define PREFETCH  (1<<3)

#define FMC_CPU_CLK			10000000
#define FMC_PERIPH_CLK		10000000

extern void EEPROM_Init( void );
void EEPROM_WritePage( BYTE pageWrite, DWORD* pBuf, DWORD pSize, BYTE Command );
void EEPROM_ReadPage( BYTE pageRead, DWORD* pBuf, DWORD pSize, BYTE Command );
void EEPROM_ReadAddr( DWORD addrRead, DWORD *pBuf, BYTE Command );

#endif /* end __EEPROM_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/

